#ifndef __LINQ_SENDMSG_DLG_H__
#define __LINQ_SENDMSG_DLG_H__

#include "LinqWindow.h"
#include <time.h>

#include <list>
#include <string>
#include <gtk/gtk.h>

class SendMsgDlg;

class SendMsgDlgTab {
public:
	SendMsgDlgTab(SendMsgDlg *oSendMsgDlg, const char *name);
	~SendMsgDlgTab();

	void Create();
	void Active();
	void onRecvMessage(time_t when, const char *text);

	std::string contact_name;
private:
	SendMsgDlg *oSendMsgDlg;

	GtkWidget *tab_cont;
	GtkWidget *imhtml;
	GtkWidget *bold_button, *italic_button, *underline_button, *bigfont_button, *normalfont_button,
			  *smallfont_button, *selectfont_button, *fgcolor_button, *bgcolor_button, *smilies_button;	
	GtkWidget *entry;
	GtkWidget *send_button, *warning_button, *info_button;
	

	GtkWidget *build_conv_toolbar();
	void setup_im_buttons(GtkWidget *bbox);
	GtkWidget *setup_im_pane();	

	static void on_bold_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_italic_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_underline_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_bigfont_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_normalfont_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_smallfont_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_selectfont_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_fgcolor_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_bgcolor_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_smilies_button_toggled(GtkToggleButton *togglebutton, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_send_button_clicked(GtkWidget *widget, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_warning_button_clicked(GtkWidget *widget, SendMsgDlgTab *oSendMsgDlgTab);
	static void on_info_button_clicked(GtkWidget *widget, SendMsgDlgTab *oSendMsgDlgTab);
	static gboolean on_entry_key_press_event(GtkWidget *entry, GdkEventKey *event, SendMsgDlgTab *oSendMsgDlgTab);
};

class SendMsgDlg : public LinqWindow{
public:
	SendMsgDlg();
	~SendMsgDlg();
	void Show(const char *name, time_t when = 0, const char *text = NULL);

	std::list<SendMsgDlgTab *> tabList;
	GtkWidget *notebook;
private:	
	GtkWidget *window;

	void create_window();
	GtkWidget *setup_menubar();

	static gboolean on_window_deleteevent(GtkWidget * widget, GdkEvent * event, SendMsgDlg *oSendMsgDlg);
};

#endif
