#include "LinqInfo.h"

LinqOnlineInfo::LinqOnlineInfo(ONLINE_INFO &info)
{
	name = info.name;
	status = info.status;
	tcp_ver = info.tcp_ver;
	ip = info.ip;
	real_ip = info.real_ip;
	msg_port = info.msg_port;
}

LinqContactInfo::LinqContactInfo()
{
	gender = 0;
	birth = 0;
}

LinqContactInfo::LinqContactInfo(CONTACT_INFO &info)
{
	name = info.name;
	nick = info.nick;
	gender = info.gender;
	birth = info.birth;
	email = info.email;
	country = info.country;
	city = info.city;
	address = info.address;
	postcode = info.postcode;
	tel = info.tel;
	mobile = info.mobile;
	realname = info.realname;
	occupation = info.occupation;
	homepage = info.homepage;
	intro = info.intro;
}

LinqContactInfo::~LinqContactInfo()
{
}

void LinqContactInfo::load(DBInStream &in)
{
	in >> nick >> gender >> birth >> email >> country >> city;
	in >> address >> postcode >> tel >> mobile;
	in >> realname >> occupation >> homepage >> intro;
}

void LinqContactInfo::save(DBOutStream &out)
{
	out << nick << gender << birth << email << country << city;
	out << address << postcode << tel << mobile;
	out << realname << occupation << homepage << intro;
}


LinqContactLocalInfo::LinqContactLocalInfo()
{
	group = 0;
}

LinqContactLocalInfo::~LinqContactLocalInfo()
{
}

void LinqContactLocalInfo::load(DBInStream &in)
{
	in >> group >> remark;
}

void LinqContactLocalInfo::save(DBOutStream &out)
{
	out << group << remark;
}


LinqUserInfo::LinqUserInfo()
{
	auth = 0;
}

LinqUserInfo::LinqUserInfo(USER_INFO &info) : LinqContactInfo(info)
{
	auth = info.auth;	
}

void LinqUserInfo::load(DBInStream &in)
{
	LinqContactInfo::load(in);

	in >> auth;
}

void LinqUserInfo::save(DBOutStream &out)
{
	LinqContactInfo::save(out);
	
	out << auth;
}
