/*
 * GTK See -- an image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GTKSEE_H__
#define __GTKSEE_H__

#ifdef __cplusplus
        extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <errno.h>

gboolean get_current_image  (gchar *buffer);
void     dir_change_enter   (gchar *path);
void     refresh_list       ();
void     refresh_all        ();
void     show_browser       ();
void     gtksee_set_root    (guchar *new_root);
void     menu_edit_rename   (GtkWidget *widget, gpointer data);
void     menu_edit_timestamp(GtkWidget *widget, gpointer data);
void     menu_edit_delete   (GtkWidget *widget, gpointer data);
void     menu_help_contents (GtkWidget *widget, gpointer data);
void     menu_help_about    (GtkWidget *widget, gpointer data);
void     gtksee_main        (gchar *root);

#ifdef __cplusplus
        }
#endif /* __cplusplus */

#endif
