#include "bbs.h"

#include <sys/resource.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/telnet.h>

#ifdef SYSV
#include <sys/termios.h>
#else
#include <termios.h>
#endif

#ifdef LINUX
#include <sys/ioctl.h>
#endif


#ifdef LINUX
#define HAVE_CHKLOAD
#endif

#define SOCKET_QLEN     4

#define TH_LOW          10
#define TH_HIGH         15

#define PID_FILE		BBSHOME"/reclog/bbsd.pid"
#define LOG_FILE		BBSHOME"/reclog/bbsd.log"
#define BAD_HOST		BBSHOME"/.bad_host"
#define NOLOGIN			BBSHOME"/NOLOGIN"

#ifdef  HAVE_CHKLOAD
#define BANNER  "\r\nӭ[1;33m"BBSNAME"[m[ [1;32m"BBSHOST"[m ] [1;33m"BBSVERSION"[m Ժ...\r\n[1;36m [33m(1,10,15)[36m ƽΪ[33m %s [36m( = %d) [%s][0m\r\n"
#else
#define BANNER  "\r\nӭ[1;33m"BBSNAME"[m[ [1;32m"BBSHOST"[m] [1;33m"BBSVERSION"[m [bbsd ready]\r\n"
#endif

jmp_buf byebye;

extern  char    fromhost[60];
char    genbuf[1024];
char    status[64];

#ifdef HAVE_CHKLOAD 
char	loadstr[1024]; 
#endif

#ifdef TIMECOUNTER
extern struct MCACHE *tstrshm;
void run_time_counter( void );
#endif

char h_str[2000][32];
int ip[2000], h_total;

void loadhosts() {
        FILE *fp;
        char tmphost[80], tmp[80], tmpip[80];
        h_total=0;
        fp=fopen("etc/hosts", "r");
        while(1) {
                bzero(tmphost, 80);
                if(fscanf(fp, "%s %s %s %s", tmphost, tmp, tmp, tmpip)<0) break;
                strncpy(h_str[h_total], tmphost, 28);
                ip[h_total]=inet_addr(tmpip);
                if(h_total++>=1999) break;
        }
        fclose(fp);
}

char* gethost(int x) {
        int i;
        for(i=0; i<2000; i++) {
                if(ip[i]==0) break;
                if(ip[i]==x) return h_str[i];
        }
        return (char*) inet_ntoa(x);
}

static void telnet_init()
{
   static char svr[] = {
      IAC, WILL, TELOPT_ECHO,
      IAC, WILL, TELOPT_SGA
   };
   send(0, svr, 6, 0);
}

#include <setjmp.h>
/*
static void timeout(int sig)
{
	(void) longjmp(byebye, sig);
}
*/

static void getremotename(struct sockaddr_in * from, char *rhost)
{
#ifdef FOR_DOMAIN_NAME	
	 setjmp(byebye);
   (void) strcpy(rhost, gethost(inet_addr(inet_ntoa(from->sin_addr))));
#else 
   setjmp(byebye);
   (void)strcpy(rhost,(char *)inet_ntoa(from->sin_addr));
#endif	
}

#ifdef  HAVE_CHKLOAD
int     fkmem;

int chkload(int limit)
{
   double  cpu_load[3];
   register int i;
#ifdef BSD44
   getloadavg(cpu_load, 3);
#elif defined(LINUX)
   FILE   *fp;
   fp = fopen("/proc/loadavg", "r"); 
   if (!fp) cpu_load[0] = cpu_load[1] = cpu_load[2] = 0;
   else {
      float   av[3];
      fscanf(fp, "%g %g %g", av, av + 1, av + 2);
      fclose(fp);
      cpu_load[0] = av[0];
      cpu_load[1] = av[1];
      cpu_load[2] = av[2];
   }
#else

#include <nlist.h>

#ifdef SOLARIS
   #define VMUNIX  "/dev/ksyms"
   #define KMEM    "/dev/kmem"
   static struct nlist nlst[] = { {"avenrun"}, {0} };
#else
   #define VMUNIX  "/vmunix"
   #define KMEM    "/dev/kmem" 
   static struct nlist nlst[] = { {"_avenrun"}, {0} };
#endif
   long    avenrun[3];
   static long offset = -1;
   int     kmem;
   if ((kmem = open(KMEM, O_RDONLY)) == -1) return (1); 
   if (offset < 0) {
      (void) nlist(VMUNIX, nlst);
      if (nlst[0].n_type == 0) return (1);
      offset = (long) nlst[0].n_value;
   }
   if (lseek(kmem, offset, L_SET) == -1) { 
      close(kmem);
      return (1);
   }
   if (read(kmem, (char *) avenrun, sizeof(avenrun)) == -1) {
      close(kmem);
      return (1);
   }
   close(kmem);
#define loaddouble(la) ((double)(la) / (1 << 8)) 
   for (i = 0; i < 3; i++)
      cpu_load[i] = loaddouble(avenrun[i]);
#endif 

   i = cpu_load[0];
   if (i < limit) i = 0;
   if(i != 0 ) {
      strcpy(status,"ɣԺ");
   } else if (cpu_load[0] >= (float) 0 && cpu_load[0] < (float) 1) {
      strcpy(status, "");
   } else if (cpu_load[0] >= 1 && cpu_load[0] < (float) 10) {
      strcpy(status, "ƫ");
   } else {
      strcpy(status, "ɹ");
   }    
   sprintf(loadstr,"%.2f %.2f %.2f",cpu_load[0],cpu_load[1],cpu_load[2]); 
   return i;
}
#endif

static int mainset;		/* read file descriptor set */
static struct sockaddr_in xsin;
/*
static void reapchild()
{
   int     state, pid;
   while ((pid = waitpid(-1, &state, WNOHANG | WUNTRACED)) > 0);
}
*/
static void start_daemon()
{
   int     n;
   n = getdtablesize();
   if (fork()) 
      exit(0);
   if (setsid()==-1) 
      exit(0);
   if (fork()) 
      exit(0);
   if (fork()){ 
#ifdef TIMECOUNTER 
      (void)setgid(BBSGID);
      (void)setuid(BBSUID);
      (void)chdir(BBSHOME);
      run_time_counter(); 
#endif	
      exit(0); 
   }   
   sleep(5); /* force p-process accept login after timer run */ 
   while (n) 
      (void) close(--n);
   for (n = 1; n <= NSIG; n++) 
      (void) signal(n, SIG_IGN);
}


static void close_daemon()
{
   exit(0);
}

static void bbsd_log(char *str)
{
	char buf[256];
	time_t mytime;
	struct tm *tm;
	
	mytime = time(0);
	tm = localtime(&mytime);
	sprintf(buf, "%.2d/%.2d/%.2d %.2d:%.2d:%.2d bbsd[%d]: %s", tm->tm_year%100, tm->tm_mon+1, tm->tm_mday,
		 tm->tm_hour, tm->tm_min, tm->tm_sec, getpid(), str);
	file_append(LOG_FILE, buf);
}

static int
bind_port(port)
int     port;
{
	int     sock, on;
	sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

	on = 1;
	(void) setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *) &on, sizeof(on));

	xsin.sin_port = htons(port);
	if (bind(sock, (struct sockaddr *) & xsin, sizeof xsin) < 0) {
		sprintf(genbuf, "bbsd bind_port can't bind to %d\n", port);
		bbsd_log(genbuf);
		exit(1);
	}
	if (listen(sock, SOCKET_QLEN) < 0) {
		sprintf(genbuf,"bbsd bind_port can't listen to %d\n", port);
		bbsd_log(genbuf);
		exit(1);
	}
	FD_SET(sock, (fd_set *) & mainset);

	sprintf(genbuf,"started on port %d\n", port);
	bbsd_log(genbuf);
	
	return sock;
}

static int bad_host(char *name)
{
   FILE   *list;
   char    buf[40], *ptr;
   
   if (list = fopen(BAD_HOST, "r")) {
      while (fgets(buf, 40, list)) {
         ptr = strtok(buf, " \n\t\r");
	 if (ptr != NULL && *ptr != '#'){
	    if(!strcmp(ptr, name)){
	       fclose(list);
	       return 1;
	    }   
	    if(ptr[0] == '#')continue;
	    if(ptr[0] == '-' && !strcmp(name,&ptr[1])){
	       fclose(list);
	       return 0;
	    }
	    if(ptr[strlen(ptr)-1]=='.'&&!strncmp(ptr,name,strlen(ptr)-1)){
	       fclose(list);
	       return 1;
	    }
	    if(ptr[0]=='.'&&strlen(ptr)<strlen(name)&&
	      !strcmp(ptr,name+strlen(name)-strlen(ptr))){
	      fclose(list);
	      return 1;
	    }
	 }
      }	 
      fclose(list);
   }
   return 0;
}

#ifdef TIMECOUNTER
void  run_time_counter( void )
{
   char weeknum[7][3]={"","һ","","","","",""};
   struct tm *tm;
   time_t now; 
  
   tstrshm = NULL;
   resolve_tstrshm();
   now = tstrshm-> now;
   sleep(3);
   if(now!=tstrshm->now)//exit(0);/*check whether another time counter runing*/ 
   {
      kill(tstrshm->timer_pid, 9);
   }
   now = time(0);
   tstrshm-> now = now; 
   tstrshm->timer_pid = getpid();
   tstrshm->tm = localtime(&now);
   tm = tstrshm->tm; 
  
   while(1) {
      sprintf(tstrshm->datestring,"%4d%02d%02d%02d:%02d:%02d %2s",
         tm->tm_year+1900,tm->tm_mon+1,tm->tm_mday,
	 tm->tm_hour,tm->tm_min,tm->tm_sec,
	 weeknum[tm->tm_wday]);
      tstrshm->spare = tm->tm_sec%10;
      sleep(1);
      ++tm->tm_sec;
      if(tm->tm_sec == 30 || tm->tm_sec == 60 || tstrshm->refresh ){
         tstrshm->refresh = 0;
	 tstrshm->now = time(0);
	 tstrshm->tm = localtime(&(tstrshm->now));
      } else {
         (tstrshm->now) ++;
      }
   }
}
#endif

int main(int argc, char *argv[])
{
	extern int errno;

	register int msock, csock;	/* socket for Master and Child */
	register int nfds;	/* number of sockets */
	register int overload;
	register pid_t pid;
	register time_t uptime;
	int     readset;
	int     value;
	struct timeval tv;

	/* --------------------------------------------------- */
	/* setup standalone                                    */
	/* --------------------------------------------------- */

	start_daemon(); 
	

	/* (void) signal(SIGCHLD, reapchild); */ 
	(void) signal(SIGCHLD, SIG_IGN); /*change by quickmouse*/
	(void) signal(SIGTERM, close_daemon);


	/* --------------------------------------------------- */
	/* port binding                                        */
	/* --------------------------------------------------- */

	xsin.sin_family = AF_INET;
        if (argc > 1) csock = atoi(argv[1]) ;
        if (csock <= 0)  csock = 12345;
        msock = bind_port(csock);
        if (msock < 0) exit(1);
	nfds = msock + 1;

	/* --------------------------------------------------- */
	/* Give up root privileges: no way back from here      */
	/* --------------------------------------------------- */

	(void) setgid((gid_t)BBSGID);
	(void) setuid((uid_t)BBSUID);
	(void) chdir(BBSHOME);
	umask((mode_t)022);

	unlink(PID_FILE);
	sprintf(genbuf, "%d", getpid());
	file_append(PID_FILE, genbuf);
	
	loadhosts();
	/* --------------------------------------------------- */
	/* main loop                                           */
	/* --------------------------------------------------- */

	tv.tv_sec = 60 * 30;
	tv.tv_usec = 0;

	overload = uptime = 0;
	
	for (;;) {
#ifdef  HAVE_CHKLOAD
		pid = time(0);
		if (pid > uptime) {
			overload = chkload(overload ? TH_LOW : TH_HIGH);
			uptime = pid + overload + 45;
				/* ʱڲټ system load */
		}
#endif

again:

		readset = mainset;

		value = sizeof xsin;
		do {
			csock = accept(msock, (struct sockaddr *) & xsin, &value);
		} while (csock < 0 && errno == EINTR);

		if (csock < 0) {
			goto again;
		}

#ifdef HAVE_CHKLOAD
        sprintf(genbuf, BANNER, loadstr, TH_LOW, status);
#else
        sprintf(genbuf, BANNER);
#endif
       (void) write(csock, genbuf, strlen(genbuf));

#ifdef  HAVE_CHKLOAD
                if (overload) {
			sleep(3);
                        (void) close(csock);
                        continue;
                }
#endif

#ifdef NOLOGIN
		{
			FILE   *fp;
			char    buf[256];
#define MYBANNER "\r\nFB2000 [bbsd NOLOGIN] ϵͳ[1;33mͣ½[m״̬\r\n[1;32m[վάɾ \'[36m~bbs/NOLOGIN[32m\' ״̬][m\r\n\r\nϵͳͣ½״̬ġ桿\r\n"

			if ((fp = fopen(NOLOGIN, "r")) != NULL) {
				(void) write(csock, MYBANNER, strlen(MYBANNER));
				while (fgets(buf, 255, fp) != 0) {
					strcat(buf, "\r");
					(void) write(csock, buf, strlen(buf));
				}
				fclose(fp);
				sleep(5);
				close(csock);
				continue;
			}
		}
#endif

		pid = fork();

		if (!pid) {

#ifdef  HAVE_CHKLOAD
			(void) close(fkmem);
#endif

			while (--nfds >= 0)
				(void) close(nfds);
			(void) dup2(csock, 0);
			(void) close(csock);
			(void) dup2(0, 1);

			getremotename(&xsin, fromhost);	

			/* ban  bad host / bad user */
			if (bad_host(fromhost)) exit(1);

			bbssetenv("REMOTEHOST", fromhost, 1);

#ifdef TIMECOUNTER
			tstrshm = NULL;
			resolve_tstrshm();
#endif

			telnet_init();
			nice(3);	/* lower priority .. */
			bzero(&uinfo, sizeof(uinfo));
			start_client();
		}
		(void) close(csock);
	}
}
