/*
    Pirate Bulletin Board System
    Copyright (C) 1990, Edward Luke, lush@Athena.EE.MsState.EDU
    Eagles Bulletin Board System
    Copyright (C) 1992, Raymond Rocker, rocker@rock.b11.ingr.com
                        Guy Vega, gtvega@seabass.st.usm.edu
                        Dominic Tynes, dbtynes@seabass.st.usm.edu
    Firebird Bulletin Board System
    Copyright (C) 1996, Hsien-Tsung Chang, Smallpig.bbs@bbs.cs.ccu.edu.tw
                        Peng Piaw Foong, ppfoong@csie.ncu.edu.tw

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*/

/*
$Id: main.c,v 1.1.1.1 2000/08/25 14:20:33 deardragon Exp $
*/
#include "bbs.h"

#ifndef DLM
#undef  ALLOWGAME
#else 
long int bank;
int NowInGame = NA;
#endif

#define BADLOGINFILE    "logins.bad"
#define VISITLOG	BBSHOME"/.visitlog"
int     ERROR_READ_SYSTEM_FILE = NA;
int		fd;
int     RMSG = YEA;
int     msg_num = 0;
int     count_friends = 0, count_users = 0;
int     iscolor = 1;
int     mailXX = 0;
//char   *getenv();
int     friend_login_wall();
char   *sysconf_str();
struct user_info *t_search();
void    r_msg();
void    count_msg();
void    c_recover();
void    tlog_recover();
void 	refreshdate();
int     listmode;
int     numofsig = 0;
jmp_buf byebye;
extern struct BCACHE *brdshm;
FILE   *ufp;
int     talkrequest = NA;
/* int ntalkrequest = NA ; */
int     enter_uflags;
time_t  lastnote;

struct user_info uinfo;

#ifndef BBSD
char    tty_name[20];
#endif
char	fromhost[60];

char    BoardName[STRLEN];
char    ULIST[STRLEN];
int     utmpent = -1;
time_t  login_start_time;
int     showansi = 1;
int     started = 0;

char	GoodWish[20][STRLEN-3];
int	WishNum=0;
int     orderWish=0;
extern int enabledbchar;

#ifdef ALLOWSWITCHCODE
int	convcode = 0;
extern void resolve_GbBig5Files();
#endif

void
log_usies(mode, mesg)
char   *mode, *mesg;
{
	char    buf[256], *fmt;
	#ifndef TIMECOUNTER
	time_t  now;
	now = time(0);
	getdatestring(now,NA);
	#else
	getnowdatestring();
	#endif
	fmt = currentuser.userid[0] ? "%s %s %-12s %s\n" : "%s %s %s%s\n";
	sprintf(buf, fmt, datestring, mode, currentuser.userid, mesg);
	file_append("usies", buf);
}

void
u_enter()
{
   enter_uflags = currentuser.flags[0];
   memset(&uinfo, 0, sizeof(uinfo));
   uinfo.active = YEA;
   uinfo.pid = getpid();
   /* ʹ SYSOP Ȩ ID ½ʱԶָ״̬ */
   if (!HAS_PERM(PERM_CLOAK))
      currentuser.flags[0] &= ~CLOAK_FLAG;
   if (HAS_PERM(PERM_LOGINCLOAK) && (currentuser.flags[0] & CLOAK_FLAG))
      uinfo.invisible = YEA;
   uinfo.mode = LOGIN;
   uinfo.pager = 0;
#ifdef BBSD
   uinfo.idle_time = time(0);
#endif
   if (DEFINE(DEF_DELDBLCHAR))
      enabledbchar=1;
   else
      enabledbchar=0;
   if (DEFINE(DEF_FRIENDCALL)) {
      uinfo.pager |= FRIEND_PAGER;
   }
   if (currentuser.flags[0] & PAGER_FLAG) {
      uinfo.pager |= ALL_PAGER;
      uinfo.pager |= FRIEND_PAGER;
   }
   if (DEFINE(DEF_FRIENDMSG)) {
      uinfo.pager |= FRIENDMSG_PAGER;
   }
   if (DEFINE(DEF_ALLMSG)) { 
      uinfo.pager |= ALLMSG_PAGER;
      uinfo.pager |= FRIENDMSG_PAGER;
   }
   uinfo.uid = usernum;
   strncpy(uinfo.from, fromhost, 60);
   if (!DEFINE(DEF_NOTHIDEIP)) {
      uinfo.from[22] = 'H';
   }    
#if !defined(BBSD) && defined(SHOW_IDLE_TIME)
   strncpy(uinfo.tty, tty_name, 20);
#endif
   iscolor = (DEFINE(DEF_COLOR)) ? 1 : 0;
   strncpy(uinfo.userid, currentuser.userid, 20);
   strncpy(uinfo.realname, currentuser.realname, 20); 
   strncpy(uinfo.username, currentuser.username, NAMELEN);
   getfriendstr();
   getrejectstr();
   if (HAS_PERM(PERM_EXT_IDLE))
      uinfo.ext_idle = YEA;
		
   listmode = 0;	/* һ, ¼ utmpent λʧܼ */
   while ( 1 ) {
      utmpent = getnewutmpent(&uinfo);
      if ( utmpent >= 0 || utmpent == -1 ) break;
      if ( utmpent == -2 && listmode <= 100 ) {
         listmode++;
	 usleep(250);		/* Ϣķ֮һٽ */
	 continue;	
      }
      if ( listmode > 100 ) {	/*  */
         sprintf(genbuf, "getnewutmpent(): too much times, give up.");
	 report(genbuf);
	 prints("getnewutmpent(): ʧ̫, . رվ.\n");
	 sleep(3);
	 exit(0);
      }
   } 
   if (utmpent < 0) {
      sprintf(genbuf, "Fault: No utmpent slot for %s\n", uinfo.userid);
      report(genbuf);
   }
   listmode = 0; 
   digestmode = NA;
}

void
setflags(mask, value)
int     mask, value;
{
	if (((currentuser.flags[0] & mask) && 1) != value) {
		if (value)
			currentuser.flags[0] |= mask;
		else
			currentuser.flags[0] &= ~mask;
	}
}

void u_exit()
{ /*ЩźŵĴҪص, ʱȺسʱ  (ylsdd)
      źŻᵼд, µұkick user*/

   signal(SIGHUP, SIG_DFL);
   signal(SIGALRM, SIG_DFL);
   signal(SIGPIPE, SIG_DFL);
   signal(SIGTERM, SIG_DFL);
   signal(SIGUSR1, SIG_IGN);
   signal(SIGUSR2, SIG_IGN);
   
   setflags(PAGER_FLAG, (uinfo.pager & ALL_PAGER));
   if (HAS_PERM(PERM_LOGINCLOAK))
      setflags(CLOAK_FLAG, uinfo.invisible);

   if (!ERROR_READ_SYSTEM_FILE) {
      time_t  stay;
      set_safe_record();
      stay = time(0) - login_start_time;
      currentuser.stay += stay;
      currentuser.lastlogout = time(0);
      substitute_record(PASSFILE, &currentuser, sizeof(currentuser), usernum);
   }
   
   uinfo.invisible = YEA;
   uinfo.sockactive = NA;
   uinfo.sockaddr = 0;
   uinfo.destuid = 0;
#if !defined(BBSD) && defined(SHOW_IDLE_TIME)
   strcpy(uinfo.tty, "NoTTY");
#endif
   uinfo.pid = 0;
   uinfo.active = NA;
    /* update_utmp(); */
 if( (fd = open(ULIST, O_RDWR | O_CREAT, 0600)) > 0 )
   {
    flock(fd, LOCK_EX);
   }
   update_utmp();
   if( fd > 0 )
   {
    flock(fd, LOCK_UN);
    close(fd);
   }
   utmpent = -1; 
}

int
cmpuids(uid, up)
char   *uid;
struct userec *up;
{
	return !ci_strncmp(uid, up->userid, sizeof(up->userid));
}

int
dosearchuser(userid)
char   *userid;
{
	int     id;
	if ((id = getuser(userid)) != 0) {
		if (cmpuids(userid, &lookupuser)) {
			memcpy(&currentuser, &lookupuser, sizeof(currentuser));
			return usernum = id;
		}
	}
	memset(&currentuser, 0, sizeof(currentuser));
	return usernum = 0;
}


void
talk_request()
{
	signal(SIGUSR1, talk_request);
	talkrequest = YEA;
	bell();
	bell();
	bell();
	sleep(1);
	bell();
	bell();
	bell();
	bell();
	bell();
	return;
}

void abort_bbs()
{
   extern int	child_pid; 
#ifdef ALLOWGAME   
   char inGame[STRLEN];
   if(NowInGame==YEA){
      setuserfile(inGame,"inGame");
      if(dashf(inGame)) unlink(inGame);
   }   
#endif

   if(child_pid) kill(child_pid, 9);
   if (  uinfo.mode==POSTING||uinfo.mode==SMAIL||uinfo.mode==EDIT
       ||uinfo.mode==EDITUFILE||uinfo.mode==EDITSFILE||uinfo.mode==EDITANN)
      keep_fail_post();
   if (started) {
      time_t  stay;
      stay = time(0) - login_start_time;
      sprintf(genbuf, "Stay: %3ld (%s)", stay / 60, currentuser.username);
      log_usies("AXXED", genbuf);
      u_exit();
   }
   exit(0);
}

int
cmpuids2(unum, urec)
int     unum;
struct user_info *urec;
{
	return (unum == urec->uid);
}

int
count_multi(uentp)
struct user_info *uentp;
{
	static int count;
	if (uentp == NULL) {
		int     num = count;
		count = 0;
		return num;
	}
	if (!uentp->active || !uentp->pid)
		return 0;
	if (uentp->uid == usernum)
		count++;
	return 1;
}

int
count_user()
{
	count_multi(NULL);
	apply_ulist(count_multi);
	return count_multi(NULL);
}

void
multi_user_check()
{
	struct user_info uin;
	int     logins, mustkick=0;
	if (HAS_PERM(PERM_MULTILOG))
		return;		/* don't check sysops */

	/* allow multiple guest user */
	logins = count_user();

	if (heavyload() && logins) {
		prints("[1;33mǸ, Ŀǰϵͳɹ, ظ Login[m\n");
		oflush();
		sleep(3);
		exit(1);
	}
	if (!strcasecmp("guest", currentuser.userid)) {
		if (logins > MAXGUEST) {
			prints("[1;33mǸ, Ŀǰ̫ [1;36mguest[33m, Ժԡ[m\n");
			oflush();
			sleep(3);
			exit(1);
		}
		return;
	}  else if (logins >= MULTI_LOGINS) {
		prints("[1;32mΪȷվȨ, վøʺŵ½ %d \n[0m",MULTI_LOGINS);
		prints("[1;36mĿǰѾʹøʺŵ½ %d Ͽӷܽ뱾վ\n[0m",logins);
		mustkick = 1;
	}
	if (!search_ulist(&uin, cmpuids2, usernum))
		return;		/* user isn't logged in */

	if (!uin.active || (uin.pid && kill(uin.pid, 0) == -1))
		return;		/* stale entry in utmp file */

	getdata(0, 0, "[1;37mɾظ login  (Y/N)? [N][m",
		genbuf, 4, DOECHO, YEA);
	if (genbuf[0] == 'N' || genbuf[0] == 'n'||genbuf[0] == '\0'){
		if ( !mustkick ) return;
		prints("[33mܱǸѾøʺŵ½ %d ԣ߽ȡ[m\n",logins);
		oflush();
		sleep(3);
		exit(1);
	} else  {
                if(!uin.pid) return ;
		kill(uin.pid, SIGHUP);   
		    //ǰSIGHUPᵼ±༭ҵʧ by sunner
                report("kicked (multi-login)");
                log_usies("KICK ", currentuser.username);
        }
}
#ifndef BBSD
void
system_init(argc, argv)
int     argc;
char  **argv;
#else
void
system_init()
#endif
{
#ifndef BBSD
	char   *rhost;
#endif
      	struct sigaction act;

	gethostname(genbuf, 256);
	sprintf(ULIST, "%s.%s", ULIST_BASE, genbuf);

#ifndef BBSD
	if (argc >= 3) {
		strncpy(fromhost, argv[2], 60);
	} else {
		fromhost[0] = '\0';
	}
	if ((rhost = getenv("REMOTEHOST")) != NULL)
		strncpy(fromhost, rhost, 60);
	fromhost[59] = '\0';
#if defined(SHOW_IDLE_TIME)
	if (argc >= 4) {
		strncpy(tty_name, argv[3], 20);
	} else {
		tty_name[0] = '\0';
	}
#endif
#endif

#ifndef lint
	signal(SIGHUP, abort_bbs);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGPIPE, SIG_IGN);
#ifdef DOTIMEOUT
	init_alarm();
	uinfo.mode = LOGIN;
	alarm(LOGIN_TIMEOUT);
#else
	signal(SIGALRM, SIG_SIG);
#endif
	signal(SIGTERM, SIG_IGN);
	signal(SIGURG, SIG_IGN);
	signal(SIGTSTP, SIG_IGN);
	signal(SIGTTIN, SIG_IGN);
#endif
	signal(SIGUSR1, talk_request);

	sigemptyset(&act.sa_mask);
	act.sa_flags = SA_NODEFER;
	act.sa_handler = r_msg;
  	sigaction(SIGUSR2, &act, NULL);	
}

void
system_abort()
{
	if (started) {
		log_usies("ABORT", currentuser.username);
		u_exit();
	}
	clear();
	refresh();
	prints("лл, ǵó !\n");
	exit(0);
}

void
logattempt(uid, frm)
char   *uid, *frm;
{
	char    fname[STRLEN];
	getdatestring(time(0),NA);
	sprintf(genbuf, "%-12.12s  %-30s %s\n",
		uid, datestring, frm);
	file_append(BADLOGINFILE, genbuf);
	sethomefile(fname, uid, BADLOGINFILE);
	file_append(fname, genbuf);

}

int check_tty_lines() {  /* dii.nju.edu.cn  zhch  2000.4.11 */
    static unsigned char buf1[]= {255, 253, 31};
    unsigned char buf2[100];
    int n;
    if(ttyname(0))
        return;
    write(0, buf1, 3);
    n= read(0, buf2, 80);
    if(n== 12) {
        if(buf2[0]!= 255|| buf2[1]!= 251|| buf2[2]!= 31)
            return;
        if(buf2[3]!= 255|| buf2[4]!= 250|| buf2[5]!= 31
                || buf2[10]!= 255|| buf2[11]!= 240)
            return;
        t_lines= buf2[9];
    }
    if(n== 9) {
        if(buf2[0]!= 255|| buf2[1]!= 250|| buf2[2]!= 31
                || buf2[7]!= 255|| buf2[8]!= 240)
            return;
        t_lines= buf2[6];
    }
    if(t_lines< 24 ||t_lines> 100) t_lines=24;
}

struct max_log_record {
        int     year;
        int     month;
        int     day;
        int     logins;
        unsigned long   visit;
}max_log;
void visitlog(void)
{
   int vfp;
   time_t now;
   struct tm *tm;
   extern struct UTMPFILE *utmpshm;
   
   vfp = open(VISITLOG,O_RDWR|O_CREAT,0644);
   if(vfp == -1) {
      report("Can NOT write visit Log to .visitlog");
      return ;
   }
   flock(vfp, LOCK_EX);
   lseek(vfp,(off_t)0,SEEK_SET);
   read(vfp, &max_log,(size_t)sizeof(max_log)); 
   if(max_log.year < 1990 || max_log.year > 2020) {
      now = time(0);
      tm = localtime(&now); 
      max_log.year = tm->tm_year+1900;
      max_log.month = tm->tm_mon+1;
      max_log.day = tm->tm_mday;
      max_log.visit = 0;
      max_log.logins = 0;
   }
   max_log.visit ++ ;
   if( max_log.logins > utmpshm->max_login_num )
      utmpshm->max_login_num = max_log.logins;
   else
      max_log.logins =  utmpshm->max_login_num;
   lseek(vfp,(off_t)0,SEEK_SET);
   write(vfp,&max_log,(size_t)sizeof(max_log));
   flock(vfp, LOCK_UN);
   close(vfp); 
   sprintf(genbuf,"[1;32m [[36m%4d%2d%2d[32m] , ¼: [[36m%d[32m] ۼƷ˴: [[36m%u[32m][m\n",
      max_log.year,max_log.month,max_log.day,max_log.logins,max_log.visit);
   prints(genbuf);
}

void
login_query()
{
   char    uid[IDLEN + 2];
   char 	passbuf[PASSLEN];
   int     curr_login_num;
   int     attempts;
   char    genbuf[STRLEN];
   char   *ptr;
   extern struct UTMPFILE *utmpshm;

   curr_login_num = num_active_users();
   if (curr_login_num >= MAXACTIVE) {
      ansimore("etc/loginfull", NA);
      oflush();
      sleep(1);
      exit(1);
   }
#ifdef BBSNAME
   strcpy(BoardName, BBSNAME);
#else
   ptr = sysconf_str("BBSNAME");
   if (ptr == NULL) ptr = "δվ";
   strcpy(BoardName, ptr);
#endif
   if (fill_shmfile(1, "etc/issue", "ISSUE_SHMKEY")) {
      show_issue();	/* is anibanner ready, remark this and put * \n\n */
   }
   prints("[1;35mӭ[1;40;33m %s  [m[[0;1;33;41m Add '.' after YourID to login for BIG5 [m]\n[0;1;32mվעʺ: [[1;36m%d[0;1;32m] [m", BoardName, MAXUSERS);
   resolve_utmp();
   if (utmpshm->usersum == 0)
      utmpshm->usersum = allusers();
   if (utmpshm->max_login_num < curr_login_num)
      utmpshm->max_login_num = curr_login_num;
   prints("[1;32mĿǰʺ: [[1;36m%d[32m] [1;32mĿǰվ: [[1;36m%d[1;32m/[1;36m%d[1;32m] \n",
      utmpshm->usersum, curr_login_num, MAXACTIVE);
//    utmpshm->usersum, curr_login_num-CountCloakMan(), MAXACTIVE);
   visitlog();

#ifdef MUDCHECK_BEFORELOGIN
   prints("[1;33mΪֹʹóʽվ밴 [1;36mCTRL + C[m : "); 
   genbuf[0] = igetkey(); 
   if ( genbuf[0] != Ctrl('C') ) {
      prints("\nԲ㲢ûа CTRL+C \n");
      oflush();
      exit(1);
   } else {
      prints("[CTRL] + [C]\n");
   }
#endif
	
   attempts = 0;
   while (1) {
      if (attempts++ >= LOGINATTEMPTS) {
         ansimore("etc/goodbye", NA);
	 oflush();
	 sleep(1);
	 exit(1);
      }
      getdata(0, 0, "[1;33mʺ[m( `[1;36mguest[m', ע`[1;31mnew[m'): ", uid, IDLEN + 1, DOECHO, YEA);
#ifdef ALLOWSWITCHCODE
      ptr = strchr(uid, '.');
      if(ptr){ convcode = 1; *ptr = '\0'; }
#endif
      if ((strcasecmp(uid,"guest")==0) && (MAXACTIVE - curr_login_num<10)) {
         ansimore("etc/loginfull", NA);
	 oflush();
	 sleep(1);
	 exit(1);
      }
      if (strcasecmp(uid, "new") == 0) {
#ifdef LOGINASNEW
         memset(&currentuser, 0, sizeof(currentuser));
	 new_register();
	 ansimore3("etc/firstlogin", YEA);
	 break;
#else
         prints("[1;37mϵͳĿǰ޷ [36mnew[37m ע, [36m guest[37m ...[m\n");
#endif
      } else if (*uid == '\0'); 
      else if( !dosearchuser(uid)) {
         prints("[1;31m֤޴ ID (User ID Error)...[m\n");
      } else if (strcasecmp(uid, "guest") == 0) {
         currentuser.userlevel = 0;
	 break;
#ifdef SYSOPLOGINPROTECT
      } else if (!strcasecmp(uid,"SYSOP")&&strcmp(fromhost,"localhost")
                  &&strcmp(fromhost,"127.0.0.1")) {
         prints("[1;32m :  %s ¼ǷǷ! ![m\n", fromhost);
	 prints("[ע] ΪȫվѾ趨 SYSOP ֻܴ½\n       ȷʵǱվ SYSOP ½ BBS Ȼ: \n              telnet localhost port.\n");
	 oflush();
	 sleep( 1 );
	 exit ( 1 );
#endif
      } else {
#ifdef ALLOWSWITCHCODE
         if (!convcode)
	    convcode=!(currentuser.userdefine&DEF_USEGB);
#endif
         getdata(0,0,"[1;37m: [m",passbuf,PASSLEN,NOECHO,YEA);
	 passbuf[8] = '\0';
	 if (!checkpasswd(currentuser.passwd, passbuf)) {
	    logattempt(currentuser.userid, fromhost);
	    prints("[1;31m (Password Error)...[m\n");
	 } else {
		if( HAS_PERM(PERM_RECLUSION)&&!HAS_PERM(PERM_SYSOP)) {
		if((time(0)-currentuser.lastlogin)/(24*60*60)<30){
		prints("[1;32m˺Ѿ,ûʸس,ڹ30״̬[0m\n");
		oflush();
		sleep(1);
		exit(1);}
    	        if(askyn("ȷҪ״̬,س",NA,NA)==1)
		{
		currentuser.userlevel &= ~PERM_RECLUSION;
                substitute_record(PASSFILE, &currentuser, sizeof(struct userec),usernum);
	        Postfile("etc/ccjh", "notepad", "س--ֻ!!", 2);
		}
		else {oflush();sleep(1);exit(1);}
	    }
	    if( !HAS_PERM( PERM_BASIC ) && !HAS_PERM(PERM_SYSOP)) {
	       prints( "[1;32mʺͣ [36mSYSOP[32m ѯԭ[m\n" );
	       oflush();
	       sleep( 1 );
	       exit( 1 );
	    }
#ifdef CHECK_LESS60SEC
            if (abs(time(0)-currentuser.lastlogout)<60&&!HAS_PERM(PERM_SYSOP) &&
	        strcasecmp(currentuser.userid, "guest") != 0) {
		prints(" 60 ظվ.밴 [1;36mCtrl+C[m ȷ: ");
		genbuf[0] = igetkey();
		if ( genbuf[0] != Ctrl('C') ) {
		   prints("\nԲûа CTRL+C ܽ뱾վ\n");
		   prints("֪ͨվԱ, лл.\n");
		   oflush();
		   sleep(3);
		   exit(1);
		}
		prints("\n"); 
            }
#endif

#ifdef CHECK_SYSTEM_PASS
            if (HAS_PERM(PERM_SYSOP)) {
	       if(!check_systempasswd()){
		  prints("\n, ǩ ! !\n");
		  oflush();
		  sleep(2);
		  exit(1);
               }
            }
#endif
	    bzero(passbuf, PASSLEN - 1);
	    break;
	 }
      }
   }
   multi_user_check(); 
   if (!term_init(currentuser.termtype)) {
      prints("Bad terminal type.  Defaulting to 'vt100'\n");
      strcpy(currentuser.termtype, "vt100");
      term_init(currentuser.termtype);
   }
   check_tty_lines(); /* 2000.03.14 */ 
   sethomepath(genbuf, currentuser.userid);
   mkdir(genbuf, 0755);
   login_start_time = time(0);
}

int
valid_ident(ident)
char   *ident;
{
	static char *invalid[] = {"unknown@", "root@", "gopher@", "bbs@",
	"guest@", "nobody@", "www@", NULL};
	int     i;
	if (ident[0] == '@')
		return 0;
	for (i = 0; invalid[i] != NULL; i++)
		if (strstr(ident, invalid[i]) != NULL)
			return 0;
	return 1;
}

void
write_defnotepad()
{
	currentuser.notedate = time(0);
	set_safe_record();
	substitute_record(PASSFILE, &currentuser, sizeof(currentuser), usernum);
	return;
}

void
notepad_init()
{
	FILE   *check;
	char    notetitle[STRLEN];
	char    tmp[STRLEN * 2];
	char   *fname, *bname, *ntitle;
	long int maxsec;
	time_t  now;
	maxsec = 86400;
	lastnote = 0;
	if ((check = fopen("etc/checknotepad", "r")) != NULL) {
		fgets(tmp, sizeof(tmp), check);
		lastnote = atol(tmp);
		fclose(check);
	} 
	now = time(0);
	if ((now - lastnote) >= maxsec) {
		move(t_lines - 1, 0);
		prints("ԲϵͳԶţԺ.....");
		refresh();
		check = fopen("etc/checknotepad", "w");
		lastnote = now - (now % maxsec);
		fprintf(check, "%d", lastnote);
		fclose(check);
		if ((check = fopen("etc/autopost", "r")) != NULL) {
			while (fgets(tmp, STRLEN, check) != NULL) {
				fname = strtok(tmp, " \n\t:@");
				bname = strtok(NULL, " \n\t:@");
				ntitle = strtok(NULL, " \n\t:@");
				if (fname == NULL || bname == NULL || ntitle == NULL)
					continue;
				else {
				#ifndef TIMECOUNTER
					getdatestring(now,NA);
				#else	
					getnowdatestring();
				#endif	
					sprintf(notetitle, "[%8.8s %6.6s] %s",datestring+6, datestring + 23,ntitle);
					if (dashf(fname)) {
						Postfile(fname, bname, notetitle, 1);
						sprintf(tmp, "%s Զ", ntitle);
						report(tmp);
					}
				}
			}
			fclose(check);
		}
		#ifndef TIMECOUNTER
		getdatestring(now,NA);
		#else
		getnowdatestring();
		#endif
		sprintf(notetitle, "[%s] ԰¼", datestring);
		if (dashf("etc/notepad", "r")) {
			Postfile("etc/notepad", "notepad", notetitle, 1);
			unlink("etc/notepad");
		}
		report("Զʱ");
	}
	return;
}


void
user_login()
{
   char    fname[STRLEN];
   if (strcmp(currentuser.userid, "SYSOP") == 0) {
      currentuser.userlevel = ~0;	/* SYSOP gets all permission bits */
      substitute_record(PASSFILE, &currentuser, sizeof(currentuser), usernum);
   }
   sprintf(genbuf,"From: %s",fromhost);
   log_usies("ENTER", genbuf);
   u_enter();
   sprintf(genbuf,"Enter - %s",fromhost);
   report(genbuf);
   started = 1;
   if((!HAS_PERM(PERM_MULTILOG|PERM_SYSOP)) && count_user() > MULTI_LOGINS 
      && strcmp(currentuser.userid,"guest")){ 
      report("kicked (multi-login)[©֮]");
      abort_bbs();
   }
   initscr();
#ifdef USE_NOTEPAD
   notepad_init(); 
   if (strcmp(currentuser.userid, "guest") != 0 ) {
      if (DEFINE(DEF_NOTEPAD)) {
         int     noteln;
	 if (lastnote > currentuser.notedate) 
	    currentuser.noteline = 0;
	 noteln = countln("etc/notepad");
	 if (currentuser.noteline == 0) {
	    shownotepad();
	 } else if ((noteln - currentuser.noteline) > 0) {
	    move(0, 0);
	    ansimore2("etc/notepad", NA, 0, noteln - currentuser.noteline + 1);
	    igetkey();
	    clear();
	 }
	 currentuser.noteline = noteln;
	 write_defnotepad();
      }
   }
#endif
   if(show_statshm("0Announce/bbslist/countusr", 0) && DEFINE(DEF_GRAPH)) {
      refresh();
      pressanykey();
   }
   if ((vote_flag(NULL, '\0', 2 /* µWelcome û */ ) == 0)) {
      if (dashf("Welcome")) {
         ansimore("Welcome", YEA);
	 vote_flag(NULL, 'R', 2 /* дµWelcome */ );
      }
   } else {
      if (fill_shmfile(3, "Welcome2", "WELCOME_SHMKEY"))
         show_welcomeshm();
   }
   show_statshm("etc/posts/day", 1);
   refresh();
   move(t_lines - 2, 0);
   clrtoeol();
   if(currentuser.numlogins < 1) {
      currentuser.numlogins = 0;
      getdatestring(time(0),NA);
      prints("[1;36m  [33m1[36m ΰݷñվסɡ\n");
      prints(" һ뱾վʱΪ [33m%s[m ", datestring);
   } else {
      getdatestring(currentuser.lastlogin,NA);
      prints("[1;36m  [33m%d[36m ΰݷñվϴǴ [33m%s[36m վ\n", currentuser.numlogins + 1, currentuser.lasthost);
      prints(" ϴʱΪ [33m%s[m ", datestring);
   }
   igetkey();
   WishNum = 9999; 
   setuserfile(fname, BADLOGINFILE);
   if (ansimore(fname, NA) != -1) {
      if (askyn("Ҫɾļ¼", YEA, YEA) == YEA)
         unlink(fname);
   }

   set_safe_record();
   check_uinfo(&currentuser,0);
   strncpy(currentuser.lasthost, fromhost, 16);
   currentuser.lasthost[15] = '\0';	/* dumb mistake on my part */
   currentuser.lastlogin = time(0);
   if(currentuser.ident[0]=='\0')strncpy(currentuser.ident,fromhost,NAMELEN-1);

   if (HAS_PERM(PERM_SYSOP) || !strcmp(currentuser.userid, "guest")) 
      currentuser.lastjustify = time(0);
   if (    HAS_PERM(PERM_LOGINOK) 
       && (abs(time(0)-currentuser.lastjustify)>=REG_EXPIRED * 86400)) {
#ifdef MAILCHECK       
          currentuser.email[0]= '\0';
#endif	  
	  currentuser.address[0]='\0';
	  currentuser.userlevel &= ~(PERM_LOGINOK | PERM_PAGE | PERM_MESSAGE);
	  mail_file("etc/expired", currentuser.userid, "¸˵");
   }
   currentuser.numlogins++;
#ifdef ALLOWGAME
   check_downline();
   update_game_money();
#endif
   if (currentuser.firstlogin == 0) {
      currentuser.firstlogin = time(0)-7*86400;
   }
   substitute_record(PASSFILE, &currentuser, sizeof(currentuser), usernum);
   check_register_info();
}


void
set_numofsig()
{
	int     sigln;
	char    signame[STRLEN];
	setuserfile(signame, "signatures");
	sigln = countln(signame);
	numofsig = sigln / MAXSIGLINES;
	if ((sigln % MAXSIGLINES) != 0)
		numofsig += 1;
}

#ifdef CHK_FRIEND_BOOK
int
chk_friend_book()
{
	FILE   *fp;
	int     idnum, n = 0;
	char    buf[STRLEN], *ptr;
	if ((fp = fopen("friendbook", "r")) == NULL)
		return 0;

	move(10, 0);
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		char    uid[14];
		char    msg[STRLEN];
		struct user_info *uin;
		ptr = strstr(buf, "@");
		if (ptr == NULL)
			continue;
		ptr++;
		strcpy(uid, ptr);
		ptr = strstr(uid, "\n");
		*ptr = '\0';
		idnum = atoi(buf);
		if (idnum != usernum || idnum <= 0)
			continue;
		uin = t_search(uid, NA);
		sprintf(msg, "%s Ѿվ", currentuser.userid);
		if (!uinfo.invisible && uin != NULL && !DEFINE(DEF_NOLOGINSEND)
			&& do_sendmsg(uin, msg, 2, uin->pid) == 1) {
			prints("[1m%s[m 㣬ϵͳѾվϢ\n", uid);
		} else
			prints("[1m%s[m 㣬ϵͳ޷絽硣\n", uid);
		n++;
		del_from_file("friendbook", buf);
		if (n > 15) {
			pressanykey();
			move(10, 0);
			clrtobot();
		}
	}
	fclose(fp);
	if(n) {
	   move(8,0);
	   prints("[1mϵͳѰб:[m");
	}
	return n;
}
#endif

int
check_maxmail()
{
   extern char currmaildir[STRLEN];
   int     maxmail, maxsize, mailsize,oldnum;
   maxmail = (HAS_PERM(PERM_SYSOP)) ?
		MAX_SYSOPMAIL_HOLD : (HAS_PERM(PERM_BOARDS)) ?
		MAX_BMMAIL_HOLD : MAX_MAIL_HOLD;

   set_safe_record();
   oldnum = currentuser.nummails;
   currentuser.nummails=get_num_records(currmaildir, sizeof(struct fileheader));
   if(oldnum != currentuser.nummails)
      substitute_record(PASSFILE, &currentuser, sizeof(currentuser), usernum);
   if(HAS_PERM(PERM_MAILINFINITY)) return 0;
   maxsize = getmailboxsize(currentuser.userlevel);
   mailsize = getmailsize(currentuser.userid); 
   if (currentuser.nummails > maxmail || mailsize > maxsize) {
      mailXX = 1;
      clear();
      move(4,0);
      if( currentuser.nummails > maxmail ) 
         prints("˽żߴ %d , ʼ: %d \n", 
	    currentuser.nummails, maxmail);
      if( mailsize > maxsize )
         prints("żߴ %d K: %d K\n",
	    mailsize, maxsize);
      prints("˽żѾ, 䣬޷ʹñվŹܡ\n");
      if (currentuser.nummails > maxmail + 100 ) {
         sprintf(genbuf, "˽ż: %d ", currentuser.nummails);
	 securityreport(genbuf);
      }
      if (mailsize  > maxsize + 1000 ) {
         sprintf(genbuf, "˽ż: %d K", mailsize);
	 securityreport(genbuf);
      }
   } 
   else{
   mailXX=0;
   }
   return mailXX;
}
#ifndef BBSD
int
main(argc, argv)
int     argc;
char  **argv;
#else
void
start_client()
#endif
{
   load_sysconf();

#ifdef ALLOWSWITCHCODE
   resolve_GbBig5Files();
#endif

#ifndef BBSD
   if (argc < 2 || *argv[1] != 'h') {
      printf("You cannot execute this program directly.\n");
      exit(-1);
   }
   system_init(argc, argv);
#else
   system_init();
#endif

   if (setjmp(byebye)) {
      system_abort();
   }
#ifndef BBSD
   get_tty();
   init_tty();
#endif

   login_query();
   user_login();
   m_init();
   RMSG = NA;
   clear();
   c_recover();
#ifdef TALK_LOG
   tlog_recover();		/* 990713.edwardc for talk_log recover */
#endif

   if (strcmp(currentuser.userid, "guest")) {
      if (HAS_PERM(PERM_ACCOUNTS) && dashf("new_register")) {
         prints("[0;1m\n\n");
	 prints("[33mĿǰʹߵȺ[37m\n\n");
#ifdef SHOW_THANKYOU
         prints("лʹ FB2000ǳϣܾ [32mˮվ [telnet fb2000.dhs.org][37m \n");
	 prints("ܵĻ[45;33mرʹ![0;1;37m BUGʡ飡ǳл\n\n");
	 prints("ϣʱ˽ FB2000 붩ġFB2000 ͨѶʼб\n");
	 prints("ķдŸ fb2000-request@list.cn99.comдsubscribe");
#endif
         pressanykey();
      }
      if(check_maxmail()) pressanykey();
#ifdef CHK_FRIEND_BOOK
      if(chk_friend_book()) pressanykey();
#endif
      move(9, 0);
      clrtobot();
      if (!DEFINE(DEF_NOLOGINSEND))
         if (!uinfo.invisible) apply_ulist(friend_login_wall);
      clear();
      set_numofsig();
   }

   ActiveBoard_Init();

   fill_date();		/*  */
   b_closepolls();	/* رͶƱ */

   num_alcounter();
   if (count_friends > 0 && DEFINE(DEF_LOGFRIEND)) t_friends();
#ifdef BIRTHDAY_POST      
   if(is_birth(currentuser)&&currentuser.lastlogout/86400<time(0)/86400){
      char happybirthday[STRLEN];
      sprintf(happybirthday,"%s, տ",currentuser.userid);
      Postfile("etc/birthday","notepad",happybirthday,1);
   }
#endif   
   while (1) {
      if (DEFINE(DEF_NORMALSCR))
         domenu("TOPMENU");
      else
         domenu("TOPMENU2");
      Goodbye();
   }
}

int     refscreen = NA;

int
egetch()
{
	int     rval;
	check_calltime();
	if (talkrequest) {
		talkreply();
		refscreen = YEA;
		return -1;
	}
	while (1) {
		rval = igetkey();
		if (talkrequest) {
			talkreply();
			refscreen = YEA;
			return -1;
		}
		if (rval != Ctrl('L'))
			break;
		redoscr();
	}
	refscreen = NA;
	return rval;
}

char   *
boardmargin()
{
	static char buf[STRLEN];
	if (selboard)
		sprintf(buf, " [%s]", currboard);
	else {
		brc_initial(DEFAULTBOARD);
		if (!getbnum(currboard))
			setoboard(currboard);
		selboard = 1;
		sprintf(buf, " [%s]", currboard);
	}
	return buf;
}

void update_endline()
{
   char    buf[255],fname[STRLEN], *ptr;
   time_t  now;
   FILE *fp;
   int     i, allstay, foo, foo2;

   move(t_lines - 1, 0);
   clrtoeol();

   if (!DEFINE(DEF_ENDLINE)) return;

   now = time(0);
   #ifndef TIMECOUNTER
   allstay = getdatestring (now,YEA); // allstay Ϊǰ
   #else
   allstay = getnowdatestring();
   #endif
   if(allstay == 0){
nowishfile:   
      resolve_boards();
      strcpy(datestring, brdshm->date);
      allstay = 1;
   }   
   if(allstay < 5 ){
      allstay = (now - login_start_time) / 60;
      sprintf(buf, "[[36m%.12s[33m]", currentuser.userid);
      num_alcounter();
      prints( "[1;44;33m[[36m%29s[33m][[36m%4d[33m/[1;36m%3d[33m][[36m%1s%1s%1s%1s%1s%1s[33m]ʺ%-24s[[36m%3d[33m:[36m%2d[33m][m", 
         datestring,count_users,count_friends,(uinfo.pager&ALL_PAGER)?"P":"p",
	 (uinfo.pager&FRIEND_PAGER)?"O":"o",(uinfo.pager&ALLMSG_PAGER)?"M":"m",
	 (uinfo.pager&FRIENDMSG_PAGER)?"F":"f",(DEFINE(DEF_MSGGETKEY))?"X":"x",
	 (uinfo.invisible==1)?"C":"c",buf,(allstay /60)%1000,allstay%60);
      return ;
   }   
   setuserfile(fname, "HaveNewWish");
   if(WishNum == 9999 || dashf(fname)){
      if(WishNum != 9999) unlink(fname);
      WishNum = 0;
      orderWish = 0;

      if(is_birth(currentuser)){
         strcpy(GoodWish[WishNum],
"                     տ!   ǵҪӴ :P                   ");
	 WishNum ++;
      }	 

      setuserfile(fname, "GoodWish");
      if( (fp = fopen(fname,"r")) != NULL){ 
         for(; WishNum < 20 ;){
	    if(fgets(buf,255,fp)==NULL) break;
	    buf[STRLEN-4] = '\0';
	    ptr = strtok(buf, "\n\r");
	    if(ptr == NULL || ptr[0] == '#') continue;
	    strcpy(buf,ptr);
	    for(ptr=buf;*ptr==' '&& *ptr!=0; ptr ++);
	    if(*ptr == 0 || ptr[0] == '#') continue;
	    for(i= strlen(ptr)-1; i<0; i--)
	       if(ptr[i] != ' ') break;
	    if(i < 0) continue; 
	    foo = strlen(ptr);
	    foo2 = (STRLEN - 3 - foo) / 2;
	    strcpy(GoodWish[WishNum], "");
	    for(i = 0; i < foo2; i++) strcat(GoodWish[WishNum], " ");
	    strcat(GoodWish[WishNum], ptr);
	    for(i=0;i<STRLEN-3-(foo+foo2);i++)strcat(GoodWish[WishNum]," ");
	    GoodWish[WishNum][STRLEN-4] = '\0';
	    WishNum ++;
	 }
         fclose(fp);
      }
   }   
   if(WishNum == 0) goto nowishfile;
   if(orderWish>=WishNum*2)orderWish=0;
   prints("[0;1;44;33m[[36m%s[33m][m",GoodWish[orderWish/2]);
   orderWish ++;
}

/*ReWrite by SmallPig*/
void
showtitle(title, mid)
char   *title, *mid;
{
	char    buf[STRLEN], *note;
	int     spc1, spc2;
	note = boardmargin();
	spc1 = 39 + num_ans_chr(title) - strlen(title) - strlen(mid) / 2;
	if(spc1 < 2) spc1 = 2;
	spc2 = 79 - (strlen(title)-num_ans_chr(title)+spc1 + strlen(note) + strlen(mid));
	//if (spc1 < 1) spc1 = 1;
	if (spc2 < 1) spc2 = 1;
	move(0, 0);
	clrtoeol();
	sprintf(buf, "%*s", spc1, "");
	if (!strcmp(mid, BoardName))
		prints("[1;44;33m%s%s[37m%s[1;44m", title, buf, mid);
	else if (mid[0] == '[')
		prints("[1;44;33m%s%s[5;36m%s[m[1;44m", title, buf, mid);
	else
		prints("[1;44;33m%s%s[36m%s", title, buf, mid);
	sprintf(buf, "%*s", spc2, "");
	prints("%s[33m%s[m\n", buf, note);
	update_endline();
	move(1, 0);
}
void
firsttitle(title)
char   *title;
{
	char    middoc[30];
	if (chkmail())
		strcpy(middoc, strstr(title,"б")?"[ż M ]":"[ż]");
	else if (mailXX == 1)
		strcpy(middoc, "[żż!]");
	else
		strcpy(middoc, BoardName);

	showtitle(title, middoc);
}
void docmdtitle(title, prompt)
char   *title, *prompt;
{
        firsttitle(title);
        move(1, 0);
        clrtoeol();
        prints("%s", prompt);
        clrtoeol();
}

void c_recover()
{
   char    fname[STRLEN], buf[STRLEN];
   int     a;
   sprintf(fname, "home/%c/%s/%s.deadve", toupper(currentuser.userid[0]), currentuser.userid, currentuser.userid);
   if (!dashf(fname) || strcmp(currentuser.userid, "guest") == 0) return;
   clear();
   strcpy(genbuf, "");
   getdata(0,0, "[1;32mһ༭ҵжϣ(S) дݴ浵 (M) Ļ (Q) ˣ[M][m", genbuf, 2, DOECHO, YEA); 
   switch (genbuf[0]) { 
      case 'Q':
      case 'q': 
         unlink(fname); 
	 break;
      case 'S': 
      case 's': 
         while (1) {
	    strcpy(genbuf, "");
	    getdata(2, 0, "[1;33mѡݴ浵 [0-7] [0][m", genbuf, 2, DOECHO, YEA);
	    if (genbuf[0] == '\0') a = 0;
	    else a = atoi(genbuf); 
	    if (a >= 0 && a <= 7) {
	       sprintf(buf, "home/%c/%s/clip_%d", toupper(currentuser.userid[0]), currentuser.userid, a);
	       if (dashf(buf)) {
		  getdata(3,0, "[1;31mݴ浵Ѵڣǻ򸽼? (O) (A) [O][m", genbuf, 2, DOECHO, YEA);
		  switch (genbuf[0]) {
		     case 'A':
		     case 'a':
		        f_cp(fname, buf, O_APPEND);
			unlink(fname);
			break;
                     default:
			unlink(buf);
			rename(fname, buf);
			break;
                  }
               } else  rename(fname, buf);
               break;
            }
         }
	 break; 
      default:
	 mail_file(fname, currentuser.userid, "Ĳ...");
	 unlink(fname);
	 break; 
   }
}

#ifdef TALK_LOG
void
tlog_recover()
{
   char    buf[256];
   sprintf(buf, "home/%c/%s/talk_log", toupper(currentuser.userid[0]), currentuser.userid);

   if (strcasecmp(currentuser.userid, "guest") == 0 || !dashf(buf)) return;

   clear();
   strcpy(genbuf, "");
   getdata(0, 0, "[1;32mһ¼, Ҫ .. (M) Ļ (Q) ˣ[Q][m", genbuf, 2, DOECHO, YEA);

   if (genbuf[0] == 'M' || genbuf[0] == 'm'){
      mail_file(buf, currentuser.userid, "¼");
   }
   unlink(buf);
   return;
}
#endif
