/* bbstop.c -- compute the top login/stay/post */
/* $Id: bbstop.c,v 1.1.1.1 2000/08/25 14:20:33 deardragon Exp $ */

#include <stdio.h>
#define REAL_INFO
#include "bbs.h"

struct userec aman;
struct userec allman[ MAXUSERS ];
char   passwd_file[ 256 ];
char   *home_path;

int login_cmp(b, a)
struct userec *a, *b;
{
    return (a->numlogins - b->numlogins);
}

int post_cmp(b, a)
struct userec *a, *b;
{
    return (a->numposts - b->numposts);
}

int stay_cmp(b, a)
struct userec *a, *b;
{
    return (a->stay - b->stay);
}

int perm_cmp(b, a)
struct userec *a, *b;
{
        return (a->numlogins/3+a->numposts+a->stay/3600)-(b->numlogins/3+b->numposts+b->stay/3600);
}

int age_cmp(b, a)
struct userec *a, *b;
{
        return ((time(0)-a->firstlogin)/86400)-((time(0)-b->firstlogin)/86400);
}
// Add by hightman
int money_cmp(b, a)
struct userec *a, *b;
{
    return (b->firstlogin - a->firstlogin);
}
// Add end
//Add by jieer bbs.dqpi.edu.cn
int nummedals_cmp(b, a)
struct userec *a, *b;
{
   return (a->nummedals - b-> nummedals);
}
//Add End
top_login( num )
{
    int i, j, rows = (num + 1) / 2;
    char buf1[ 80 ], buf2[ 80 ];

    printf("\n\n%s", "\
[1;37m              ===========  [1;36m  վа [37m   ============ \n\n\
        ǳ                       ǳ             \n\
==== ===============================   ==== ================================\n[0m\
");
    for (i = 0; i < rows; i++) {
        sprintf(buf1,  "[%2d] %-10.10s %-14.14s %3d",
            i+1, allman[ i ].userid, allman[ i ].username, 
            allman[ i ].numlogins );
        j = i + rows ;
        sprintf(buf2,  "[%2d] %-10.10s %-14.14s   %3d", 
            j+1, allman[ j ].userid, allman[ j ].username, 
            allman[ j ].numlogins );

        printf("%-39.39s%-39.39s[m\n", buf1, buf2); 
    }
}

top_stay( num )
{
    int i, j, rows = (num + 1) / 2;
    char buf1[ 80 ], buf2[ 80 ];

    printf("\n\n%s", "\
[1;37m              ===========   [36m վʱа [37m   ============ \n\n\
        ǳ           ʱ          ǳ           ʱ \n\
==== ================================  ==== ================================\n[0m\
");
    for (i = 0; i < rows; i++) {
        sprintf(buf1,  "[%2d] %-10.10s %-14.14s%4d:%2d",
            i+1, allman[ i ].userid, allman[ i ].username, 
            allman[ i ].stay/3600,(allman[ i ].stay%3600)/60 );
        j = i + rows ;
        sprintf(buf2,  "[%2d] %-10.10s %-14.14s%4d:%2d", 
            j+1, allman[ j ].userid, allman[ j ].username, 
             allman[ j ].stay/3600,(allman[ j ].stay%3600)/60 );

        printf("%-39.39s%-39.39s[m\n", buf1, buf2); 
    }
}

top_post( num )
{
    int i, j, rows = (num + 1) / 2;
    char buf1[ 80 ], buf2[ 80 ];

    printf("\n\n%s", "\
              [1;37m===========  [36m  ۴а [37m   ============ \n\n\
        ǳ                       ǳ             \n\
==== ===============================  ===== ================================\n[0m\
");
    for (i = 0; i < rows; i++) {
        sprintf(buf1,  "[%2d] %-10.10s %-14.14s %3d",
            i+1, allman[ i ].userid, allman[ i ].username, 
            allman[ i ].numposts );
        j = i + rows;
        sprintf(buf2,  "[%2d] %-10.10s %-14.14s   %3d", 
            j+1, allman[ j ].userid, allman[ j ].username, 
            allman[ j ].numposts );

        printf("%-39.39s%-39.39s[m\n", buf1, buf2);
    }
}

top_perm( num )
{
    int i, j, rows = (num + 1) / 2;
    char buf1[ 80 ], buf2[ 80 ];

    printf("\n\n%s", "\
              [1;37m===========    [36mֻܱа[37m    ============ \n\
                   [32m ʽվ/3++վСʱ[37m\n\
        ǳ                       ǳ               \n\
==== ===============================   ==== =================================\n[0m\
");
    for (i = 0; i < rows; i++) {
        sprintf(buf1,  "[%2d] %-10.10s %-14.14s %5d",
            i+1, allman[ i ].userid, allman[ i ].username, 
            (allman[ i ].numlogins/3)+allman[ i ].numposts+(allman[ i ].stay/3600));
        j = i + rows;
        sprintf(buf2,  "[%2d] %-10.10s %-14.14s   %5d", 
            j+1, allman[ j ].userid, allman[ j ].username, 
            (allman[ j ].numlogins/3)+allman[ j ].numposts+(allman[ j ].stay/3600) );

        printf("%-39.39s%-39.39s[m\n", buf1, buf2);
    }
}

top_age( num )
{
    int i,j, rows = (num + 1) / 2;
    char buf1[80] , buf2[80];
    int k=0;
    while(1)
      {if(allman[k].firstlogin<1000) k++; else break;}

    printf("\n\n%s", "\
              [1;37m===========    [36mעа[37m    ============ \n\
        ǳ                       ǳ               \n\
==== ===============================   ==== =================================\n[0m\
");
    for (i = k; i < rows+k; i++) {
        sprintf(buf1,  "[%2d] %-10.10s %-14.14s %5d",
            i+1-k, allman[ i ].userid, allman[ i ].username, 
            ((time(0)-allman[ i ].firstlogin))/86400);
        j = i + rows;
        sprintf(buf2,  "[%2d] %-10.10s %-14.14s   %5d", 
            j+1-k, allman[ j ].userid, allman[ j ].username, 
             ((time(0)-allman[ j ].firstlogin))/86400);

        printf("%-39.39s%-39.39s[m\n", buf1, buf2);
    }
}
top_nummedals(num)
{
    int i, j, rows =(num+1)/2;
    char buf1[80], buf2[80];
    time_t now;
    now=time(0);
    printf("\n\n%s", "\
    [1;37m           ===========  [36m     а [37m   ============
\n\n\
        ǳ                      ǳ           \n\
==== ================================= ===== ===============================[0;0;1m\n");
      for (i = 0; i < rows; i++) {
        sprintf(buf1,  "[%2d] %-10.10s %-12.12s %8d",
            i+1, allman[ i ].userid, allman[ i ].username,
            allman[i].nummedals);
        j = i + rows;
        sprintf(buf2,  "[%2d] %-10.10s %-12.12s %6d",
            j+1, allman[ j ].userid, allman[ j ].username,
            allman[j].nummedals);

        printf("%-39.39s%-39.39s[0;1m\n", buf1, buf2);
}
}

//add by hightman
top_money( num )
{
    int i;
    char buf1[ 80 ];
    int k=0;
    while(1)
      {if(allman[k].firstlogin<1000) k++; else break;}

    printf("\n\n%s", "\
              [1;37m===========  [36m  մа [37m   ============
\n\n\
        ǳ           Ǯ            ǳ            Ǯ \n\
==== ================================= ===== ===============================[0m\n");
    for (i=k; i < 50+k; i++) {
        sprintf(buf1,  "[%2d] %-10.10s %-12.12s %s",
            i+1-k, allman[ i ].userid, allman[ i ].username,
            Ctime(allman[i].firstlogin));
        //sprintf(buf2,  "[%2d] %-10.10s %-12.12s %6d",
         //   j+1-k, allman[ j ].userid, allman[ j ].username,
          //  allman[j].firstlogin);

        printf("\t%s[m\n", buf1);
    }
}
//add end


main(argc, argv)
int  argc;
char **argv;
{
    FILE *inf;
    int  i, no = 0,mode=0;

    if (argc < 4 ) {
        printf("Usage: %s bbs_home num_top mode\nmode=(0All 1Logins 2Posts 3Stay 4perm 5age 6money 7medals)\n", argv[ 0 ]);
        exit( 1 );
    }

    home_path = argv[ 1 ];
    sprintf(passwd_file, "%s/.PASSWDS", home_path);
    
    no = atoi( argv[ 2 ] );
    mode=atoi(argv[ 3 ]);
    if(mode>5||mode<1)
        mode=0;
    if (no == 0) no = 20;

    inf = fopen( passwd_file, "rb" );

    if (inf == NULL) { 
        printf("Sorry, the data is not ready.\n"); 
        exit( 0 ); 
    }

    for (i=0; ; i++) {
        if (fread(&allman[ i ], sizeof( aman ), 1, inf ) <= 0) break;
        if(strcmp(allman[ i ].userid,"guest")==0)
        {
                i--;
                continue;
        }
    }

    if(mode==1||mode==0)
    {
            qsort(allman, i, sizeof( aman ), login_cmp);
            top_login( no );
    }

    if(mode==2||mode==0)
    {
            qsort(allman, i, sizeof( aman ), post_cmp);
            top_post( no );
    }

    if(mode==3||mode==0)
    {
            qsort(allman, i, sizeof( aman ), stay_cmp);
            top_stay( no );
    }
    if(mode==4||mode==0)
    {
            qsort(allman, i, sizeof( aman ), perm_cmp);
            top_perm( no );
    }
	if(mode==5||mode==0)
    {
            qsort(allman, i, sizeof( aman ), age_cmp);
            top_age( no );
    }
	// Add by hightman
    if(mode==6||mode==0)
    {
           qsort(allman, i, sizeof( aman ), money_cmp);
           top_money( no );
    }
// Add end
// Add by jieer bbs.dqpi.edu.cn
   if(mode==7||mode==0)
    {
 	      	qsort(allman, i, sizeof( aman ),nummedals_cmp);
		top_nummedals( no );
    }
// Add End
    printf("\n");
}
